/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.morefood.block;

import net.mcreator.morefood.block.entity.GrillingToasterBlockEntity;
import net.mcreator.morefood.procedures.DebugStickUsedOnGrillingToasterProcedure;
import net.mcreator.morefood.procedures.GrillingToasterOnTickUpdateProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GrillingToasterBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public GrillingToasterBlock() {
        super(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.METAL).strength(1.0f, 10.0f).noOcclusion().pushReaction(PushReaction.DESTROY).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)GrillingToasterBlock.box((double)0.5, (double)0.0, (double)7.1, (double)14.5, (double)3.3, (double)8.9), (VoxelShape[])new VoxelShape[]{GrillingToasterBlock.box((double)14.5, (double)9.5, (double)4.5, (double)15.5, (double)11.5, (double)11.5), GrillingToasterBlock.box((double)14.5, (double)0.0, (double)4.5, (double)15.5, (double)2.0, (double)11.5), GrillingToasterBlock.box((double)14.5, (double)2.0, (double)4.5, (double)15.5, (double)9.5, (double)7.5), GrillingToasterBlock.box((double)14.5, (double)2.0, (double)8.5, (double)15.5, (double)9.5, (double)11.5), GrillingToasterBlock.box((double)12.5, (double)3.3, (double)7.1, (double)14.5, (double)11.5, (double)8.9), GrillingToasterBlock.box((double)0.5, (double)3.3, (double)7.1, (double)3.5, (double)11.5, (double)8.9), GrillingToasterBlock.box((double)0.5, (double)0.0, (double)8.9, (double)14.5, (double)11.5, (double)11.5), GrillingToasterBlock.box((double)0.5, (double)0.0, (double)4.5, (double)14.5, (double)11.5, (double)7.1), GrillingToasterBlock.box((double)14.5, (double)2.9, (double)7.75, (double)15.9, (double)3.4, (double)8.25), GrillingToasterBlock.box((double)15.9, (double)2.9, (double)6.95, (double)17.9, (double)3.6, (double)8.95), GrillingToasterBlock.box((double)3.7, (double)3.5, (double)7.3, (double)12.1, (double)11.5, (double)8.7), GrillingToasterBlock.box((double)4.9, (double)11.5, (double)7.3, (double)10.9, (double)12.5, (double)8.7), GrillingToasterBlock.box((double)6.4, (double)12.5, (double)7.3, (double)9.4, (double)13.5, (double)8.7)});
            case Direction.NORTH -> Shapes.or((VoxelShape)GrillingToasterBlock.box((double)1.5, (double)0.0, (double)7.1, (double)15.5, (double)3.3, (double)8.9), (VoxelShape[])new VoxelShape[]{GrillingToasterBlock.box((double)0.5, (double)9.5, (double)4.5, (double)1.5, (double)11.5, (double)11.5), GrillingToasterBlock.box((double)0.5, (double)0.0, (double)4.5, (double)1.5, (double)2.0, (double)11.5), GrillingToasterBlock.box((double)0.5, (double)2.0, (double)8.5, (double)1.5, (double)9.5, (double)11.5), GrillingToasterBlock.box((double)0.5, (double)2.0, (double)4.5, (double)1.5, (double)9.5, (double)7.5), GrillingToasterBlock.box((double)1.5, (double)3.3, (double)7.1, (double)3.5, (double)11.5, (double)8.9), GrillingToasterBlock.box((double)12.5, (double)3.3, (double)7.1, (double)15.5, (double)11.5, (double)8.9), GrillingToasterBlock.box((double)1.5, (double)0.0, (double)4.5, (double)15.5, (double)11.5, (double)7.1), GrillingToasterBlock.box((double)1.5, (double)0.0, (double)8.9, (double)15.5, (double)11.5, (double)11.5), GrillingToasterBlock.box((double)0.1, (double)2.9, (double)7.75, (double)1.5, (double)3.4, (double)8.25), GrillingToasterBlock.box((double)-1.9, (double)2.9, (double)7.05, (double)0.1, (double)3.6, (double)9.05), GrillingToasterBlock.box((double)3.9, (double)3.5, (double)7.3, (double)12.3, (double)11.5, (double)8.7), GrillingToasterBlock.box((double)5.1, (double)11.5, (double)7.3, (double)11.1, (double)12.5, (double)8.7), GrillingToasterBlock.box((double)6.6, (double)12.5, (double)7.3, (double)9.6, (double)13.5, (double)8.7)});
            case Direction.EAST -> Shapes.or((VoxelShape)GrillingToasterBlock.box((double)7.1, (double)0.0, (double)1.5, (double)8.9, (double)3.3, (double)15.5), (VoxelShape[])new VoxelShape[]{GrillingToasterBlock.box((double)4.5, (double)9.5, (double)0.5, (double)11.5, (double)11.5, (double)1.5), GrillingToasterBlock.box((double)4.5, (double)0.0, (double)0.5, (double)11.5, (double)2.0, (double)1.5), GrillingToasterBlock.box((double)4.5, (double)2.0, (double)0.5, (double)7.5, (double)9.5, (double)1.5), GrillingToasterBlock.box((double)8.5, (double)2.0, (double)0.5, (double)11.5, (double)9.5, (double)1.5), GrillingToasterBlock.box((double)7.1, (double)3.3, (double)1.5, (double)8.9, (double)11.5, (double)3.5), GrillingToasterBlock.box((double)7.1, (double)3.3, (double)12.5, (double)8.9, (double)11.5, (double)15.5), GrillingToasterBlock.box((double)8.9, (double)0.0, (double)1.5, (double)11.5, (double)11.5, (double)15.5), GrillingToasterBlock.box((double)4.5, (double)0.0, (double)1.5, (double)7.1, (double)11.5, (double)15.5), GrillingToasterBlock.box((double)7.75, (double)2.9, (double)0.1, (double)8.25, (double)3.4, (double)1.5), GrillingToasterBlock.box((double)6.95, (double)2.9, (double)-1.9, (double)8.95, (double)3.6, (double)0.1), GrillingToasterBlock.box((double)7.3, (double)3.5, (double)3.9, (double)8.7, (double)11.5, (double)12.3), GrillingToasterBlock.box((double)7.3, (double)11.5, (double)5.1, (double)8.7, (double)12.5, (double)11.1), GrillingToasterBlock.box((double)7.3, (double)12.5, (double)6.6, (double)8.7, (double)13.5, (double)9.6)});
            case Direction.WEST -> Shapes.or((VoxelShape)GrillingToasterBlock.box((double)7.1, (double)0.0, (double)0.5, (double)8.9, (double)3.3, (double)14.5), (VoxelShape[])new VoxelShape[]{GrillingToasterBlock.box((double)4.5, (double)9.5, (double)14.5, (double)11.5, (double)11.5, (double)15.5), GrillingToasterBlock.box((double)4.5, (double)0.0, (double)14.5, (double)11.5, (double)2.0, (double)15.5), GrillingToasterBlock.box((double)8.5, (double)2.0, (double)14.5, (double)11.5, (double)9.5, (double)15.5), GrillingToasterBlock.box((double)4.5, (double)2.0, (double)14.5, (double)7.5, (double)9.5, (double)15.5), GrillingToasterBlock.box((double)7.1, (double)3.3, (double)12.5, (double)8.9, (double)11.5, (double)14.5), GrillingToasterBlock.box((double)7.1, (double)3.3, (double)0.5, (double)8.9, (double)11.5, (double)3.5), GrillingToasterBlock.box((double)4.5, (double)0.0, (double)0.5, (double)7.1, (double)11.5, (double)14.5), GrillingToasterBlock.box((double)8.9, (double)0.0, (double)0.5, (double)11.5, (double)11.5, (double)14.5), GrillingToasterBlock.box((double)7.75, (double)2.9, (double)14.5, (double)8.25, (double)3.4, (double)15.9), GrillingToasterBlock.box((double)7.05, (double)2.9, (double)15.9, (double)9.05, (double)3.6, (double)17.9), GrillingToasterBlock.box((double)7.3, (double)3.5, (double)3.7, (double)8.7, (double)11.5, (double)12.1), GrillingToasterBlock.box((double)7.3, (double)11.5, (double)4.9, (double)8.7, (double)12.5, (double)10.9), GrillingToasterBlock.box((double)7.3, (double)12.5, (double)6.4, (double)8.7, (double)13.5, (double)9.4)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 1);
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        GrillingToasterOnTickUpdateProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        world.scheduleTick(pos, (Block)this, 1);
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        DebugStickUsedOnGrillingToasterProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GrillingToasterBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity == null ? false : blockEntity.triggerEvent(eventID, eventParam);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof GrillingToasterBlockEntity) {
                GrillingToasterBlockEntity be = (GrillingToasterBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)be);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof GrillingToasterBlockEntity) {
            GrillingToasterBlockEntity be = (GrillingToasterBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

